<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});


// $router->post('/login',['middleware' => 'auth', 'uses' => 'UsersController@authenticate']);

$router->post('/login','UsersController@authenticate');

// Qoutes
$router->get('/qoutes', 'QoutesController@listQoutes');

$router->get('/transactions', 'QoutesController@getTransactions');

$router->get('/single-qoute/{waybill}', 'QoutesController@getSingleQuote');

$router->post('/newqoute', 'QoutesController@insertQoute');

$router->put('/updateqoute/{waybill}', ['uses' => 'QoutesController@updateQoute']);

$router->delete('/deleteqoute/{id}', 'QoutesController@deleteQoute');


// Packages
$router->get('/allpackages', 'PackagesController@listPackages');

$router->post('/addpackage/', 'PackagesController@insertPackage');

// Calculations
$router->post('/calculated', 'CalculateController@calculateRate');

// Drivers
$router->get('/get_drivers', 'DriversController@get_drivers');
$router->get('/single-driver/{driver_id}', 'DriversController@getSingleDriver');
$router->post('/register_driver', 'DriversController@register_driver');


// Emails
$router->post('/sendreminder', 'QoutesController@sendReminder');
$router->post('/sendcustom', 'QoutesController@sendCustom');
$router->post('/sendupdate', 'QoutesController@sendUpdate');

// Tests
// $router->post('/test_email', 'QoutesController@test_emails');
$router->get('/sendemail', 'PackagesController@sendEmail');
