<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use App\Qoutes;
use App\Packages;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use App\Mail\MyEmail;
use App\Mail\ReminderEmail;
use App\Mail\CustomEmail;

use Auth;


class QoutesController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth', ['except' => ['insertQoute']]);
    }

    // Get all Qoutes and their items and groups
    public function QouteData(Request $request){


    }


    // List all Qoutes
    public function listQoutes(Request $request){

        $Qoutes = Qoutes::orderBy('date_created', 'DESC')->get();

        return response()->json($Qoutes);

    }

    // Send Reminder
    public function sendReminder(Request $request){

        $Qoute = new Qoutes;
        $Package = new Packages;

        if (Mail::to("mekgwele@gmail.com")->send(new ReminderEmail($Qoute, $Package))) {
            return "Mail sent";
        }
    }

    // Send Custom Email
    public function sendCustom(Request $request){

        $Qoute = new Qoutes;
        $Package = new Packages;

        if (Mail::to("mekgwele@gmail.com")->send(new CustomEmail($Qoute, $Package))) {
            return "Mail sent";
        }
    }

    // send UPDATE
    public function sendUpdate(Request $request){

        $Qoute = new Qoutes;
        $Package = new Packages;

        if (Mail::to("mekgwele@gmail.com")->send(new MyEmail($Qoute, $Package))) {
            return "Mail sent";
        }
    }




    // GET QUOTE BY ID
    public function getSingleQuote(Request $request, $waybill){

        // ->where('status', '<>', 1)
        $qoute = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('qoute_id', '=', $waybill)
                     ->orderBy('date_created', 'DESC')
                     ->first();

        $package = DB::table('packages')
                     ->select(DB::raw('*'))
                     ->where('waybill', '=', $waybill)
                     ->orderBy('date_created', 'DESC')
                     ->get();

        $driver = DB::table('drivers')
                     ->select(DB::raw('*'))
                     ->where('driver_id', '=', $qoute->driver_id)
                     ->first();


        $single_quote = array(
                      'qoute'     => $qoute,
                      'package'     => $package,
                      'driver'     => $driver,
                  );

        return response()->json($single_quote);

    }


    // Get transactions
    public function getTransactions(Request $request){

        // ->where('status', '<>', 1)
        $pending = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('status', '=', 0)
                     ->orderBy('date_created', 'DESC')
                     ->get();

        $pickups = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('status', '=', 1)
                     ->orderBy('date_modified', 'DESC')
                     ->get();

        $saved = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('status', '=', 2)
                     ->orderBy('date_created', 'DESC')
                     ->get();

        $cancelled = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('status', '=', 3)
                     ->orderBy('date_created', 'DESC')
                     ->get();
        $inroute = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('status', '=', 4)
                     ->orderBy('date_created', 'DESC')
                     ->get();


        $transactions = array(
                      'pending'     => $pending,
                      'pickups'     => $pickups,
                      'saved'       => $saved,
                      'cancelled'   => $cancelled,
                      'inroute'     => $inroute,
                  );

        return response()->json($transactions);

    }



    // Delete a Qoute
    public function deleteQoute($id, Request $request){
        $Qoute = Qoutes::where('id', $id)->delete();

        if ($Qoute) {
            return "Qoute delete";
        }else{
            return "Something went wrong, Please try again";
        }
    }

    // Create new Qoute
    public function insertQoute(Request $request){

        $Qoute = new Qoutes;
        $Package = new Packages;

        $Qoute->qoute_id = str_replace(' ', '', $request->qoute_id);
        $Qoute->cust_name = $request->cust_name;
        $Qoute->surname = $request->surname;
        $Qoute->cellphone = $request->cellphone;
        $Qoute->email_addr = $request->email_addr;
        $Qoute->company_name = $request->company_name;
        $Qoute->destination_address = $request->destination_address;
        $Qoute->pickup_address = $request->pickup_address;
        $Qoute->collection_distance = $request->collection_distance;
        $Qoute->destination_distance = $request->destination_distance;
        $Qoute->service_type = $request->service_type;
        $Qoute->receival_method = $request->receival_method;
        $Qoute->final_price = $request->final_price;
        $Qoute->vat_price = $request->vat_price;
        $Qoute->mincharge_price = $request->mincharge_price;
        $Qoute->per_kg_price = $request->per_kg_price;
        $Qoute->fuel_price = $request->fuel_price;
        $Qoute->pickup_postal_code = $request->pickup_postal_code;
        $Qoute->branch = $request->branch;
        $Qoute->status = $request->status;
        $Qoute->note = $request->special_note;

        $qouteinput = $request->all();


        if (empty($Qoute->pickup_address)) {
            return "empty";
        }

        if ($Qoute->save($qouteinput)) {
            
            Mail::to($request->email_addr)->send(new MyEmail($Qoute, $Package));

            return "success";
        }else{
            return "Something went wrong, Please try again";
        }

    }

    // Update existing Qoute
    public function updateQoute($waybill, Request $request){

        $Qoute = Qoutes::where('qoute_id', $waybill)->update(array('status' => $request->status, 'driver_id' => $request->driver_id));

        if (empty($request->status)) {
            return "Please fill in the title";
        }

        if ($Qoute) {
            return "success";
        }else{
            return "Something went wrong, Please try again";
        }

    }


}
